VERSION 5.00
Begin VB.UserControl ucPhysicsCanvas 
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ScaleHeight     =   3600
   ScaleWidth      =   4800
End
Attribute VB_Name = "ucPhysicsCanvas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'this ucPhysicsCanvas-Control is used, to encapsulate the Surface-Handling in
'a reusable Container, so that the amount of Code within the Main-Form is reduced
'Its Coord-System differs from normal Cairo-Canvas-Binding insofar, that it works Bottom-Up
Option Explicit

Event MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
Event MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
Event MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

Private mDXMode As Boolean, mDXWaitForVerticalBlanc As Boolean
Private mStretchFac As Double

Public Srf As cCairoSurface, CC As cCairoContext

Public Sub Refresh(Optional ByVal Stretched As Boolean)
Static StretchSrf As cCairoSurface
  If Not Stretched Then 'the easy case... we can render both modes (DX-Mode and normal Surface-mode) simply this way to our Control-hDC:
    Srf.DrawToDC UserControl.hDC
    
  Else 'in stretched Mode, we can render the "DX-marked-content" directly from Srf (by using the optional Params)
    If mDXMode Then 'the fast DX-Hardware-Stretching does understand the normal optional Params, after (automatically) uploading our fixed (800x600) rendering-surface as a Texture
      
      Srf.DrawToDC UserControl.hDC, 0, 0, UserControl.ScaleWidth, UserControl.ScaleHeight
    
    Else 'and in case of our Standard-Surface-Fallback, HighQuality-Stretching per cairo is usually faster than the GDI-based (HalfTone) Stretching within .DrawToDC...
      
      'so we just ensure a second Buffer here in the correct Dimensions...
      If StretchSrf Is Nothing Then
        Set StretchSrf = Cairo.CreateSurface(UserControl.ScaleWidth, UserControl.ScaleHeight)
      ElseIf StretchSrf.Width <> UserControl.ScaleWidth Or StretchSrf.Height <> UserControl.ScaleHeight Then
        Set StretchSrf = Cairo.CreateSurface(UserControl.ScaleWidth, UserControl.ScaleHeight)
      End If

      '...and use Cairo to stretch from Srf (which holds our current Simulation-Image) to StretchSrf first in an intermediate step
      StretchSrf.CreateContext.RenderSurfaceContent Srf, 0, 0, StretchSrf.Width, StretchSrf.Height

      'followed finally by a normal (unstretched) rendering to the DC (now from StretchSrf instead from Srf)
      StretchSrf.DrawToDC UserControl.hDC
    End If
  End If
End Sub

'let's init a fixed-size-surface this time (in DXMode this area is automatically DX-Stretched into the current Usercontrols-Size)
Public Function InitSurface(Optional ByVal Width As Long = 800, Optional ByVal Height As Long = 600, Optional ByVal DXWaitForVerticalBlanc As Boolean = True, Optional ByVal ModeSwitchForced As Boolean) As Boolean
  UserControl.ScaleMode = vbPixels
  
  mDXWaitForVerticalBlanc = DXWaitForVerticalBlanc
  
  If Not ModeSwitchForced Then 'usually done this way (ModeSwitchForced = False) on the real init-call from outside...
    On Error Resume Next '...let's try a 32Bit DX-bound Surface-Creation first
      Set Srf = Cairo.CreateSurface(Width, Height, DXSurface32Bit, , UserControl.hWnd, mDXWaitForVerticalBlanc)
    If Err Then 'Ok, then let's use a normal Image-Surface as a fallback
      Err.Clear
      Set Srf = Cairo.CreateSurface(Width, Height)
    Else
      mDXMode = True
    End If
    
  Else 'forced Surface-Mode-Switching (done from inside usually, triggered by the DXMode-Property)
    If mDXMode Then
      Set Srf = Cairo.CreateSurface(Width, Height, DXSurface32Bit, , UserControl.hWnd, mDXWaitForVerticalBlanc)
    Else
      Set Srf = Cairo.CreateSurface(Width, Height)
    End If
  End If
  
  Set CC = Srf.CreateContext 'create a Context from Surface, as always
  
  'here we ensure the Bottom-Up-Behaviour in our retrieved Cairo-Context (X=0, Y=0) is then the BottomLeft-Corner
  CC.TranslateDrawings 0, Srf.Height
  CC.ScaleDrawings 1, -1
  InitSurface = mDXMode
End Function

Public Property Get DXMode() As Boolean
  DXMode = mDXMode
End Property
Public Property Let DXMode(ByVal NewValue As Boolean)
  If NewValue = mDXMode Then Exit Property 'nothing to change
  mDXMode = NewValue
  InitSurface 800, 600, mDXWaitForVerticalBlanc, True
End Property

'------------ All the rest below, is only "delegation-effort" from inside the UserControls Private-Events -------------

'and since our internal Srf already is something like a BackGround-PixelBuffer in the correct Dimensions,
'we do not need to waste even more resources by using the Usercontrols AutoRedraw-mechanism (for flicker-free refreshs)
'we just let the AutoRedraw-Property at False - and actualize the Screen-DC of our UserControl always
'completely, directly from the current Surface-Content in the normally received WM_Paint-Event below
Private Sub UserControl_Paint()
  If PhEngine Is Nothing Or Srf Is Nothing Then Exit Sub
  If PhEngine.IsRunning Then Exit Sub
  Refresh
End Sub

Private Sub UserControl_Resize() 'mStretchFac is used, to map the current UserControl-MouseCoords into "chipmunk-space" (the constant 800x600 Bottom-Up-Area)
  If Srf Is Nothing Then mStretchFac = 1: Exit Sub
  mStretchFac = Srf.Width / UserControl.ScaleWidth 'and since we keep the aspect-ratio constant, we can calculate the StretchFactor only with the Width-Coords
End Sub


'the following MouseEvents just raise "Delegate-Events" and also ensure the (scaled) Bottom-Up-Behaviour
Private Sub UserControl_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
  RaiseEvent MouseDown(Button, Shift, mStretchFac * X, mStretchFac * (UserControl.ScaleHeight - Y))
End Sub
Private Sub UserControl_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  RaiseEvent MouseMove(Button, Shift, mStretchFac * X, mStretchFac * (UserControl.ScaleHeight - Y))
End Sub
Private Sub UserControl_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
  RaiseEvent MouseUp(Button, Shift, mStretchFac * X, mStretchFac * (UserControl.ScaleHeight - Y))
End Sub

